using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.Security.Cryptography;
using System.IO;

namespace BizTalk.Tools.SSOStorage
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            //http://dotnet.org.za/deon/articles/2998.aspx

            textBox2.Text = "";
            //byte[] rand = new byte[10];

            //System.Security.Cryptography.RandomNumberGenerator rng = System.Security.Cryptography.RandomNumberGenerator.Create();
            //rng.GetNonZeroBytes(rand);

            string input = textBox1.Text;
            string password = "password";

            RijndaelManaged RijnadaelCipher = new RijndaelManaged();
            RijnadaelCipher.Padding = PaddingMode.ISO10126;

            byte[] inputBytes = Encoding.Unicode.GetBytes(input);
            byte[] saltBytes = Encoding.ASCII.GetBytes(password.Length.ToString());


            PasswordDeriveBytes secretKey = new PasswordDeriveBytes(password, saltBytes);

            ICryptoTransform Encryptor = RijnadaelCipher.CreateEncryptor(secretKey.GetBytes(32), secretKey.GetBytes(16));

            MemoryStream ms = new MemoryStream();

            CryptoStream cryptoStream = new CryptoStream(ms, Encryptor, CryptoStreamMode.Write);
            cryptoStream.Write(inputBytes, 0, inputBytes.Length);

            cryptoStream.FlushFinalBlock();

            byte[] cipherByte = ms.ToArray();

            ms.Close();
            cryptoStream.Close();

            string encryptedValue = System.Convert.ToBase64String(cipherByte);

            textBox2.Text = encryptedValue;

        }

        private void button2_Click(object sender, EventArgs e)
        {
            string encryptedInput = textBox2.Text;
            string password = "password";

            RijndaelManaged RijnadaelCipher = new RijndaelManaged();
            RijnadaelCipher.Padding = PaddingMode.ISO10126;

            byte[] encryptedBytes = Convert.FromBase64String(encryptedInput);
            byte[] saltBytes = Encoding.ASCII.GetBytes(password.Length.ToString());

            PasswordDeriveBytes secretKey = new PasswordDeriveBytes(password, saltBytes);

            ICryptoTransform Decryptor = RijnadaelCipher.CreateDecryptor(secretKey.GetBytes(32), secretKey.GetBytes(16));

            MemoryStream ms = new MemoryStream(encryptedBytes);
            

            CryptoStream cryptoStream = new CryptoStream(ms, Decryptor, CryptoStreamMode.Read);

            byte[] plainText = new byte[encryptedBytes.Length];

            int decryptedCount = cryptoStream.Read(plainText, 0, plainText.Length);

            ms.Close();
            cryptoStream.Close();

            string decryptedValue = Encoding.Unicode.GetString(plainText, 0, decryptedCount);

            textBox3.Text = decryptedValue;
        }

    }
}