﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Microsoft.ComplexEventProcessing.Adapters;
using Microsoft.ComplexEventProcessing;
using System.Threading;
using System.Xml;
using System.Xml.Xsl;
using System.Xml.Linq;
using System.Net;
using System.IO;

namespace WebOutputAdapter
{
    public class WebPointOutput: PointOutputAdapter
    {
        //store reference to CEP event
        private CepEventType bindTimeEventType;
        private string serviceAddress;
        private string httpMethod;
        private string soapAction;
        private bool isSoap;
        private XslCompiledTransform consumerXform;


        public WebPointOutput(WebOutputConfig configInfo, CepEventType eventType)
        {
            this.bindTimeEventType = eventType;
            this.serviceAddress = configInfo.ServiceAddress;
            this.httpMethod = configInfo.HttpMethod;
            this.soapAction = configInfo.SoapAction;
            this.isSoap = configInfo.IsSoap;

            //load up transform
            consumerXform = new XslCompiledTransform(false);
            consumerXform.Load(configInfo.XslPath);
        }

        public override void Resume()
        {
            new Thread(this.ConsumeEvents).Start();
        }

        public override void Start()
        {
            new Thread(this.ConsumeEvents).Start();
        }

        protected override void Dispose(bool disposing)
        {
            base.Dispose(disposing);
        }

        /// <summary>
        /// Main driver to dequeue events
        /// </summary>
        private void ConsumeEvents()
        {
            //create new point event
            PointEvent currentEvent = default(PointEvent);

            try
            {
                while (true)
                {
                    if (AdapterState.Stopping == AdapterState)
                    {
                        Stopped();

                        return;
                    }

                    if (DequeueOperationResult.Empty == Dequeue(out currentEvent))
                    {
                        Ready();
                        return;
                    }

                    //only publish insert events and ignore CTIs
                    if (currentEvent.EventKind == EventKind.Insert)
                    {
                        // ** begin service call

                        //convert CEP message to XML for transformation
                        XDocument intermediaryDoc = new XDocument(
                        new XElement("Root",
                        GetCepEventFields(currentEvent).Select(field => new XElement("Property",
                            new XElement("Name", field.Key),
                            new XElement("Value", field.Value)
                            ))));

                        //transform CEP event fields to output format
                        XDocument returnDoc = new XDocument();
                        using (XmlWriter writer = returnDoc.CreateWriter())
                        {
                            consumerXform.Transform(intermediaryDoc.CreateReader(), (XsltArgumentList)null, writer);
                        }

                        //call service
                        HttpWebRequest req = (HttpWebRequest)HttpWebRequest.Create(serviceAddress);
                        req.Method = httpMethod;
                        req.ContentType = "text/xml";
                        if (isSoap)
                            req.Headers.Add("SOAPAction", soapAction);

                        using (Stream reqStream = req.GetRequestStream())
                        {
                            var bytes = Encoding.UTF8.GetBytes(returnDoc.ToString());
                            reqStream.Write(bytes, 0, bytes.Length);
                            reqStream.Close();
                        }

                        var resp = (HttpWebResponse)req.GetResponse();

                        
                    }

                    // Every received event needs to be released.
                    ReleaseEvent(ref currentEvent);
                }
            }
            catch (AdapterException e)
            {
                System.IO.File.WriteAllText(@"C:\temp\" + System.Guid.NewGuid().ToString() + "_eventerror.txt", "Error: " + e.ToString());
            }
        }

        private Dictionary<string, string> GetCepEventFields(PointEvent currentEvent)
        {
            Dictionary<string, string> cepFields = new Dictionary<string, string>();

            for (int ordinal = 0; ordinal < bindTimeEventType.FieldsByOrdinal.Count; ordinal++)
            {
                CepEventTypeField evtField = bindTimeEventType.FieldsByOrdinal[ordinal];

                cepFields.Add(evtField.Name, currentEvent.GetField(ordinal).ToString());
            }

            return cepFields;
        }
    }
}
