﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Microsoft.ComplexEventProcessing;
using Microsoft.ComplexEventProcessing.Adapters;

namespace WebOutputAdapter
{
    

    public class WebOutputFactory : IOutputAdapterFactory<WebOutputConfig>
    {
        #region IOutputAdapterFactory<WebOutputConfig> Members

        public OutputAdapterBase Create(WebOutputConfig configInfo, EventShape eventShape, CepEventType cepEventType)
        {

            OutputAdapterBase adapter = default(OutputAdapterBase);
            adapter = new WebPointOutput(configInfo, cepEventType);

            return adapter;
        }

        #endregion

        #region IDisposable Members

        public void Dispose()
        {
        }

        #endregion
    }
}
