using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.IO;
using System.ServiceModel;
using System.Transactions;
//create namespace aliases
using WindowsSecurity = Seroter.BizTalkWCFTutorials.ServiceTestConsumer.MessageSecurity;
using TransportSecurity = Seroter.BizTalkWCFTutorials.ServiceTestConsumer.TransportSecurity;
using UsernameSecurity = Seroter.BizTalkWCFTutorials.ServiceTestConsumer.MessageUsernameSecurity;
using BothSecurity = Seroter.BizTalkWCFTutorials.ServiceTestConsumer.BothSecurity;
using DeclareSecurity = Seroter.BizTalkWCFTutorials.ServiceTestConsumer.MessageDeclareSecurity;
using AttachmentService = Seroter.BizTalkWCFTutorials.ServiceTestConsumer.Attachment;
using OperationService = Seroter.BizTalkWCFTutorials.ServiceTestConsumer.Operation;
using TranxService = Seroter.BizTalkWCFTutorials.ServiceTestConsumer.Tranx;

namespace Seroter.BizTalkWCFTutorials.ServiceTestConsumer
{
    public partial class ServiceTester : Form
    {
        public ServiceTester()
        {
            InitializeComponent();
        }


        private void btnMessageSecuritySvc_Click(object sender, EventArgs e)
        {
            try
            {
                using (WindowsSecurity.WorkforceClient client = new MessageSecurity.WorkforceClient("WSHttpEndpoint_SecureMessage"))
                {
                    string statusCode = client.GetEmployeeStatus("12345");

                    MessageBox.Show("Employee status is " + statusCode);
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show("Error occured: " + ex.ToString(), "Service Call Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void btnTransportSecuritySvc_Click(object sender, EventArgs e)
        {
            try
            {
                using (TransportSecurity.WorkforceClient client = new TransportSecurity.WorkforceClient("WSHttpEndpoint_SecureTransport"))
                {
                    string statusCode = client.GetEmployeeStatus("12345");

                    MessageBox.Show("Employee status is " + statusCode);
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show("Error occured: " + ex.ToString(), "Service Call Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void btnMessageUsernameSecuritySvc_Click(object sender, EventArgs e)
        {
            try
            {
                using (UsernameSecurity.WorkforceClient client = new UsernameSecurity.WorkforceClient("WSHttpEndpoint_SecureMessageUsername"))
                {
                    client.ClientCredentials.UserName.UserName = @"WS03VSSQL05\WCFUser";
                    client.ClientCredentials.UserName.Password = "password";
                    string statusCode = client.GetEmployeeStatus("12345");

                    MessageBox.Show("Employee status is " + statusCode);
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show("Error occured: " + ex.ToString(), "Service Call Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void btnBothSecuritySvc_Click(object sender, EventArgs e)
        {
            try
            {
                using (BothSecurity.WorkforceClient client = new BothSecurity.WorkforceClient("WSHttpEndpoint_SecureBoth"))
                {
                   string statusCode = client.GetEmployeeStatus("12345");

                    MessageBox.Show("Employee status is " + statusCode);
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show("Error occured: " + ex.ToString(), "Service Call Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void btnMessageDeclareSecuritySvc_Click(object sender, EventArgs e)
        {
            try
            {
                using (DeclareSecurity.WorkforceClient client = new DeclareSecurity.WorkforceClient("NetTcpEndpoint_SecureMessageDeclare"))
                {
                    string statusCode = client.GetEmployeeStatus("12345");

                    MessageBox.Show("Employee status is " + statusCode);
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show("Error occured: " + ex.ToString(), "Service Call Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void btnAttachmentSvc_Click(object sender, EventArgs e)
        {
            AttachmentService.OrderItem item = new AttachmentService.OrderItem();
            item.ProductId = 12345;
            item.Manufacturer = "ABC Widgets";
            item.ProductName = "Whirlybird";
            item.NumberInStock = 100;


            using (AttachmentService.OrderClient client = new AttachmentService.OrderClient("WSHttpEndpoint_Attachment"))
            {
                string status = client.SubmitOrder(item);

                MessageBox.Show("status is " + status);
            }
        }

        private void btnAttachmentSvcBinary_Click(object sender, EventArgs e)
        {
            DateTime dtNow = DateTime.Now;

            using (AttachmentService.OrderClient client = new AttachmentService.OrderClient("WSHttpEndpoint_Attachment"))
            {
                byte[] productImage = client.GetProductImage("1234");

                DateTime dtPostCall = DateTime.Now;

                MemoryStream imageStream = new MemoryStream(productImage);

                pbBinaryAttachment.Image = Image.FromStream(imageStream);

                imageStream.Close();

                TimeSpan elapsedTime = dtPostCall.Subtract(dtNow);
                MessageBox.Show("time to retrieve and render ... " + elapsedTime.TotalSeconds.ToString());
            }
        }

        private void btnTwoWayOpSvc_Click(object sender, EventArgs e)
        {
            try
            {
                using (OperationService.PatientClient client = new OperationService.PatientClient("WSHttpEndpoint_Operation"))
                {
                    OperationService.Patient p = new OperationService.Patient();
                    p.FullName = "Richard Seroter";
                    p.PatientId = "1234";
                    p.Region = "US - West";
                    p.BirthDate = DateTime.Parse("09/25/1976");

                    string statusCode = client.RegisterPatient(p);


                    MessageBox.Show("Employee status is " + statusCode);
                }
            }
            catch (FaultException ex)
            {
                MessageBox.Show("Error occured: " + ex.ToString(), "Service Call Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void btnOneWayOpAckSvc_Click(object sender, EventArgs e)
        {
            try
            {
                using (OperationService.PatientClient client = new OperationService.PatientClient("WSHttpEndpoint_Operation"))
                {
                    OperationService.Patient p = new OperationService.Patient();
                    p.FullName = "Richard Seroter";
                    p.PatientId = "1234";
                    p.Region = "US - Pacific Northwest";
                    p.BirthDate = DateTime.Parse("09/25/1976");

                    client.ModifyPatient(p);


                    MessageBox.Show("called");
                }
            }
            catch (FaultException ex)
            {
                MessageBox.Show("Error occured: " + ex.ToString(), "Service Call Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void btnOneWayOpSvc_Click(object sender, EventArgs e)
        {
            try
            {
                using (OperationService.PatientClient client = new OperationService.PatientClient("WSHttpEndpoint_Operation"))
                {

                    client.DeletePatient("9876");


                    MessageBox.Show("called");
                }
            }
            catch (FaultException ex)
            {
                MessageBox.Show("Error occured: " + ex.ToString(), "Service Call Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void btnTranxSvc_Click(object sender, EventArgs e)
        {
            try
            {
                using(TransactionScope proxyScope = new TransactionScope(TransactionScopeOption.RequiresNew))
                {

                    TranxService.EventBookingWrapperClient client = new TranxService.EventBookingWrapperClient("WsHttpEndpoint_TransactionWrapper");
                    //TranxService.EventBookingClient client = new TranxService.EventBookingClient("WsHttpEndpoint_Transaction");
                    
                        string[] attendeeList = new string[3];
                        attendeeList[0] = "123";
                        attendeeList[1] = "456";
                        attendeeList[2] = "789";

                        //client.AddAttendees(9999, attendeeList);
                        //client.ReserveRoom(9999, 80);
                        //client.ReserveCatering(9999, 80, "Beef Platter");

                        client.DoCompleteBooking(9999, attendeeList, 80, "Beef Platter");

                        MessageBox.Show("service calls completed");

                        
                        proxyScope.Complete();

                        
                    
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show("Error occured: " + ex.ToString(), "Service Call Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                
            }
        }
    }
}