using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.Collections;
using System.ServiceModel;
using Seroter.BizTalkWCFTutorials.SecurityExample;

namespace Seroter.BizTalkWCFTutorials.SecurityExample.WinUIHost
{
    public partial class SecurityExampleHost : Form
    {
        //declare servicehost objects
        ServiceHost svcHostMessageWindows = null;
        ServiceHost svcHostMessageUsername = null;
        ServiceHost svcHostMessageDeclare = null;
        ServiceHost svcHostBoth = null;
        ServiceHost svcHostTransport = null;


        public SecurityExampleHost()
        {
            InitializeComponent();
        }

        private void SecurityExampleHost_Load(object sender, EventArgs e)
        {
            //load up drop downs
            ArrayList hostList = new ArrayList();
            hostList.Add(new DictionaryEntry("Secure Message (Windows)", "lblMessageWindows"));
            hostList.Add(new DictionaryEntry("Secure Message (Username)", "lblMessageUsername"));
            hostList.Add(new DictionaryEntry("Secure Message (Declarative)", "lblMessageDeclare"));
            hostList.Add(new DictionaryEntry("Secure Transport", "lblSecureTransport"));
            hostList.Add(new DictionaryEntry("Secure Message and Transport", "lblSecureBoth"));

            cboStart.DisplayMember = "Key";
            cboStart.ValueMember = "Value";
            cboStart.DataSource = hostList;
            cboStart.SelectedIndex = 0;

            cboStop.DisplayMember = "Key";
            cboStop.ValueMember = "Value";
            cboStop.DataSource = hostList;
            cboStart.SelectedIndex = 0;
        }

                

        private void btnStart_Click(object sender, EventArgs e)
        {
            string hostName = cboStart.Text;
            string hostValue = cboStart.SelectedValue.ToString();
           
            if (hostName != null || hostName != string.Empty)
            {
                if (GetHostByName(hostName).State != CommunicationState.Opened)
                {
                    GetHostByName(hostName).Open();

                    Control statusLabel = Controls.Find(hostValue, true)[0];
                    statusLabel.Text = "Started";
                    statusLabel.ForeColor = Color.Green;
                }
            }

        }

        private void btnStop_Click(object sender, EventArgs e)
        {
            string hostName = cboStop.Text;
            string hostValue = cboStop.SelectedValue.ToString();

            if (hostName != null || hostName != string.Empty)
            {
                if (GetHostByName(hostName).State == CommunicationState.Opened)
                {
                    GetHostByName(hostName).Close();

                    Control statusLabel = Controls.Find(hostValue, true)[0];
                    statusLabel.Text = "Stopped";
                    statusLabel.ForeColor = Color.Red;
                }
            }
        }

        private ServiceHost GetHostByName(string hostName)
        {
            switch(hostName)
            {
                case "Secure Message (Windows)":
                    if(svcHostMessageWindows == null || svcHostMessageWindows.State == CommunicationState.Closed)
                    {
                        svcHostMessageWindows = new ServiceHost(typeof(WorkforceService_SecureMessageWindows));
                    }
                        
                    return svcHostMessageWindows;
                    
                case "Secure Message (Username)":
                    if (svcHostMessageUsername == null || svcHostMessageUsername.State == CommunicationState.Closed)
                     {
                        svcHostMessageUsername = new ServiceHost(typeof(WorkforceService_SecureMessageUsername));
                     }
                        
                    return svcHostMessageUsername;
                     
                case "Secure Message (Declarative)":
                    if (svcHostMessageDeclare == null || svcHostMessageDeclare.State == CommunicationState.Closed)
                    {
                        svcHostMessageDeclare = new ServiceHost(typeof(WorkforceService_SecureMessageDeclarative));
                    }
                        
                    return svcHostMessageDeclare;
                    
                case "Secure Transport":
                    if (svcHostTransport == null || svcHostTransport.State == CommunicationState.Closed)
                    {
                        svcHostTransport = new ServiceHost(typeof(WorkforceService_SecureTransport));
                    }
                        
                    return svcHostTransport;

                case "Secure Message and Transport":
                    if (svcHostBoth == null || svcHostBoth.State == CommunicationState.Closed)
                    {
                        svcHostBoth = new ServiceHost(typeof(WorkforceService_SecureBoth));
                    }
                        
                    return svcHostBoth;

                default:
                    return null;
            }

                   
        }

    }
}