using System;
using System.Collections.Generic;
using System.Text;
using System.ServiceModel;
using System.Runtime.Serialization;


namespace Seroter.BizTalkWCFTutorials.OperationExample
{

    [ServiceContract()]
    public interface IPatient
    {
        [OperationContract]
        [FaultContract(typeof(OperationExampleFault))]
        Patient RegisterPatient(Patient newPatient);

        [OperationContract]
        string QueryPatientStatus(string patientId);

        [OperationContract]
        void ModifyPatient(Patient existingPatient);
        
        //[OperationContract(IsOneWay=true)]
        //void DeletePatient(string patientId);
 

    }

    public class PatientService : IPatient
    {

        #region IPatient Members

        //two way service, complex input and output
        Patient IPatient.RegisterPatient(Patient newPatient)
        {
            if (newPatient.Region != "US - Pacific Northwest")
            {
                //print statement
                System.Diagnostics.Trace.WriteLine("Two-way service called (complex types)");

                newPatient.Status = "success";

                return newPatient;
            }
            else
            {
                throw new FaultException<OperationExampleFault>(new OperationExampleFault("Bad region supplied"));
            }
        }

        string IPatient.QueryPatientStatus(string patientId)
        {
            //print statement
            System.Diagnostics.Trace.WriteLine("Two-way service called (simple types)");

            return "success";
        }

        //implicit one way service with acknowledgement and complex input
        void IPatient.ModifyPatient(Patient existingPatient)
        {
            if (existingPatient.PatientId == "9876")
            {
              //print statement
              System.Diagnostics.Trace.WriteLine("One-way service (with ack) failed");
              throw new FaultException("Bad patient ID supplied");
            }

            //print statement
            System.Diagnostics.Trace.WriteLine("One-way service (with ack) called");
        }

        //explicit one way service
        //void IPatient.DeletePatient(string patientId)
        //{
        //    if (patientId == "9876")
        //    {
        //        //print statement
        //        System.Diagnostics.Trace.WriteLine("One-way service failed");
        //        throw new FaultException("Bad patient ID supplied");
        //    }

        //    //print statement
        //    System.Diagnostics.Trace.WriteLine("Explicit one-way service called");
        //}

        #endregion

    }

    [DataContract]
    public class Patient
    {
        string patientId;
        string doctorId;
        string fullName;
        string region;
        DateTime birthDate;
        string status;
        

        [DataMember]
        public string PatientId
        {
            get { return patientId; }
            set { patientId = value; }
        }

        [DataMember]
        public string DoctorId
        {
            get { return doctorId; }
            set { doctorId = value; }
        }

        [DataMember]
        public string FullName
        {
            get { return fullName; }
            set { fullName = value; }
        }

        [DataMember]
        public string Region
        {
            get { return region; }
            set { region = value; }
        }

        [DataMember]
        public DateTime BirthDate
        {
            get { return birthDate; }
            set { birthDate = value; }
        }

        [DataMember]
        public string Status
        {
            get { return status; }
            set { status = value; }
        }
    }

    [DataContract]
    public class OperationExampleFault
    {
        private string errorMessage;

        public OperationExampleFault(string message)
        {
            this.errorMessage = message;
        }

        [DataMember]
        public string ErrorMessage
        {
            get { return errorMessage; }
            set { errorMessage = value; }
        }
        
    }

}
