using System;
using System.Collections.Generic;
using System.Text;

using System.IO;
using Microsoft.XLANGs.BaseTypes;

namespace Seroter.BizTalkWCFTutorials.BizTalk.Utilities
{
    public class AttachmentStreamFactory : IStreamFactory
    {
        private string attachment;

        public AttachmentStreamFactory(string inAttachmentData)
        {
            attachment = inAttachmentData;
        }

        #region IStreamFactory Members

        System.IO.Stream IStreamFactory.CreateStream()
        {
            byte[] attachmentByteArray = Convert.FromBase64String(attachment);

            return new MemoryStream(attachmentByteArray);
        }

        #endregion
    }

    public class AttachmentMessageCreator
    {
        /// <summary>
        /// Called by orchestration
        /// </summary>
        /// <param name="outMessage"></param>
        /// <param name="inAttachmentData"></param>
        public void CreateAttachmentMessage(XLANGMessage outMessage, string inAttachmentData)
        {
            outMessage[0].LoadFrom(new AttachmentStreamFactory(inAttachmentData));
        }
    }
}
