using System;
using System.Collections.Generic;
using System.Text;
using System.ServiceModel;
using System.Runtime.Serialization;

using Seroter.BizTalkWCFTutorials.AttachmentTranxExample;
using TranxService = Seroter.BizTalkWCFTutorials.ServiceTestConsumer.Tranx;
using System.Transactions;
using System.ServiceModel.Transactions;

namespace Seroter.BizTalkWCFTutorials.AttachmentTranxWrapper
{
    [ServiceContract()]
    public interface IEventBookingWrapper
    {
        [OperationContract]
        [TransactionFlow(TransactionFlowOption.Mandatory)]
        string DoCompleteBooking(int eventId, string[] attendeeIds, int roomId, string menuOptionId);
    }

    public class EventBookingWrapperService : IEventBookingWrapper
    {

        #region IEventBookingWrapper Members

        [OperationBehavior(TransactionScopeRequired=true, TransactionAutoComplete=true)]
        string IEventBookingWrapper.DoCompleteBooking(int eventId, string[] attendeeIds, int roomId, string menuOptionId)
        {
            //this has a distributed trans ID because a flowed transaction is "allowed"
            System.Diagnostics.Trace.WriteLine("Trans ID (Wrapper Service): " + Transaction.Current.TransactionInformation.DistributedIdentifier.ToString());

            //use proxy class to call services
            //try
            //{
                using (TranxService.EventBookingClient client = new TranxService.EventBookingClient("WsHttpEndpoint_Transaction"))
                {
                    client.AddAttendees(eventId, attendeeIds);
                    client.ReserveRoom(eventId, roomId);
                    client.ReserveCatering(eventId, roomId, menuOptionId);
                }
            //}
            //catch (Exception ex)
            //{
             //   System.Diagnostics.Trace.WriteLine(ex.ToString());
            //}

                Transaction.Current.Rollback();

            return "success";
        }

        #endregion
    }

}
