using System;
using System.Collections.Generic;
using System.Text;
using System.ServiceModel;
using System.Runtime.Serialization;
using System.IO;


namespace Seroter.BizTalkWCFTutorials.AttachmentTranxExample
{

    [ServiceContract()]
    public interface IOrder
    {
        [OperationContract]
        string SubmitOrder(OrderItem OrderItemValue);

        [OperationContract]
        byte[] GetProductImage(string productId);
    }

    public class OrderService : IOrder
    {

        #region IOrder Members

        string IOrder.SubmitOrder(OrderItem OrderItemValue)
        {
            return "order submitted";
        }


        byte[] IOrder.GetProductImage(string productId)
        {
            return File.ReadAllBytes(@"C:\Data\My Pictures\noah.jpg");
        }

        #endregion
    }

    [DataContract]
    public class OrderItem
    {
        int productId;
        string manufacturer;
        string productName;
        int numberInStock;

        [DataMember]
        public int ProductId
        {
            get { return productId; }
            set { productId = value; }
        }

        [DataMember]
        public string Manufacturer
        {
            get { return manufacturer; }
            set { manufacturer = value; }
        }

        [DataMember]
        public string ProductName
        {
            get { return productName; }
            set { productName = value; }
        }

        [DataMember]
        public int NumberInStock
        {
            get { return numberInStock; }
            set { numberInStock = value; }
        }
    }

}
