using System;
using System.Collections.Generic;
using System.Text;
using System.ServiceModel;
using System.Runtime.Serialization;

using System.Transactions;
using System.ServiceModel.Transactions;
using System.Data;
using System.Data.SqlClient;


namespace Seroter.BizTalkWCFTutorials.AttachmentTranxExample
{


    [ServiceContract()]
    public interface IEventBooking
    {
        [OperationContract]
        [TransactionFlow(TransactionFlowOption.Allowed)]
        void AddAttendees(int eventId, string[] attendeeIds);

        /// <summary>
        /// Not allowed as it must instantiate its own transaction
        /// </summary>
        /// <param name="roomId"></param>
        /// <returns></returns>
        [OperationContract]
        [TransactionFlow(TransactionFlowOption.NotAllowed)]
        string ReserveRoom(int eventId, int roomId);

        [OperationContract]
        [TransactionFlow(TransactionFlowOption.Allowed)]
        string ReserveCatering(int eventId, int roomId, string menuOptionId);

        /// <summary>
        /// Aggregate service.
        /// </summary>
        /// <param name="attendeeIds"></param>
        /// <param name="roomId"></param>
        /// <param name="menuOptionId"></param>
        //[OperationContract]
        //[TransactionFlow(TransactionFlowOption.Mandatory)]
        //void DoCompleteBooking(int eventId, string[] attendeeIds, int roomId, string menuOptionId);
    }

    public class EventBookingService : IEventBooking
    {
        
        #region IEventBooking Members
        /// <summary>
        /// 
        /// </summary>
        /// <param name="eventId"></param>
        /// <param name="attendeeIds"></param>
        [OperationBehavior(TransactionScopeRequired = true, TransactionAutoComplete = true)]
        public void AddAttendees(int eventId, string[] attendeeIds)
        {
            //this has a distributed trans ID because a flowed transaction is "allowed"
            System.Diagnostics.Trace.WriteLine("Trans ID (AddAttendees): " + Transaction.Current.TransactionInformation.DistributedIdentifier.ToString());

            //sql conn string
            string sqlConnString = "Data Source=.;Initial Catalog=DemoDb;Integrated Security=SSPI;";
            string sqlCommString = "INSERT INTO [DemoDb].[dbo].[WCF_EventAttendees] ([EventId] ,[AttendeeId]) VALUES(@EventId, @AttendeeId)";

            using (SqlConnection sqlConn = new SqlConnection(sqlConnString))
            {
                //open connection
                sqlConn.Open();

                using (SqlCommand sqlComm = new SqlCommand(sqlCommString, sqlConn))
                {
                    foreach (string attendeeId in attendeeIds)
                    {
                        //reset params
                        sqlComm.Parameters.Clear();

                        sqlComm.Parameters.Add("@EventId", SqlDbType.Int);
                        sqlComm.Parameters[0].Value = System.Convert.ToInt32(eventId);
                        sqlComm.Parameters.Add("@AttendeeId", SqlDbType.Int);
                        sqlComm.Parameters[1].Value = System.Convert.ToInt32(attendeeId);

                        sqlComm.ExecuteNonQuery();
                    }
                }
            }

            //Transaction.Current.Rollback(new Exception("felt like it"));

        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="eventId"></param>
        /// <param name="roomId"></param>
        /// <returns></returns>
        [OperationBehavior(TransactionScopeRequired = true, TransactionAutoComplete = true)]
        public string ReserveRoom(int eventId, int roomId)
        {
            //this does NOT have a distributed trans ID because a flowed transaction is "not allowed"
            System.Diagnostics.Trace.WriteLine("Trans ID  (ReserveRoom): " + Transaction.Current.TransactionInformation.DistributedIdentifier.ToString());

            //sql conn string
            string sqlConnString = "Data Source=.;Initial Catalog=DemoDb;Integrated Security=SSPI;";
            string sqlCommString = "INSERT INTO [DemoDb].[dbo].[WCF_EventRoom] ([EventId] ,[RoomId]) VALUES(@EventId, @RoomId)";

            
            using (SqlConnection sqlConn = new SqlConnection(sqlConnString))
            {
                //open connection
                sqlConn.Open();

                using (SqlCommand sqlComm = new SqlCommand(sqlCommString, sqlConn))
                {
                    sqlComm.Parameters.Add("@EventId", SqlDbType.Int);
                    sqlComm.Parameters[0].Value = System.Convert.ToInt32(eventId);
                    sqlComm.Parameters.Add("@RoomId", SqlDbType.Int);
                    sqlComm.Parameters[1].Value = System.Convert.ToInt32(roomId);

                    sqlComm.ExecuteNonQuery();
                }
            }
            
            //only rolls back this transaction and causes other flowed tranx to rollback
            //Transaction.Current.Rollback(new Exception("bad room"));

            return "success";
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="eventId"></param>
        /// <param name="roomId"></param>
        /// <param name="menuOptionId"></param>
        /// <returns></returns>
        [OperationBehavior(TransactionScopeRequired = true, TransactionAutoComplete = true)]
        public string ReserveCatering(int eventId, int roomId, string menuOptionId)
        {
            //this has a distributed trans ID because a flowed transaction is "allowed"
            System.Diagnostics.Trace.WriteLine("Trans ID (ReserveCatering): " + Transaction.Current.TransactionInformation.DistributedIdentifier.ToString());

            //sql conn string
            string sqlConnString = "Data Source=.;Initial Catalog=DemoDb;Integrated Security=SSPI;";
            string sqlCommString = "INSERT INTO [DemoDb].[dbo].[WCF_EventCatering] ([EventId] ,[RoomId],[MenuSelectionId]) VALUES(@EventId, @RoomId, @MenuSelectionId)";


            using (SqlConnection sqlConn = new SqlConnection(sqlConnString))
            {
                //open connection
                sqlConn.Open();

                using (SqlCommand sqlComm = new SqlCommand(sqlCommString, sqlConn))
                {
                    sqlComm.Parameters.Add("@EventId", SqlDbType.Int);
                    sqlComm.Parameters[0].Value = System.Convert.ToInt32(eventId);
                    sqlComm.Parameters.Add("@RoomId", SqlDbType.Int);
                    sqlComm.Parameters[1].Value = System.Convert.ToInt32(roomId);
                    sqlComm.Parameters.Add("@MenuSelectionId", SqlDbType.VarChar);
                    sqlComm.Parameters[2].Value = menuOptionId;

                    sqlComm.ExecuteNonQuery();
                }
            }

            //causes the parent transaction to rollback any changes in flowed sub services
            //Transaction.Current.Rollback(new Exception("bad menu item"));

            return "success";
        }

        //[OperationBehavior(TransactionScopeRequired = true, TransactionAutoComplete = true)]
        //public void DoCompleteBooking(int eventId, string[] attendeeIds, int roomId, string menuOptionId)
        //{
        //    //this has a distributed trans ID because a flowed transaction is "allowed"
        //    System.Diagnostics.Trace.WriteLine("Trans ID (DoCompleteBooking): " + Transaction.Current.TransactionInformation.LocalIdentifier);

        //    //call all three sub functions (doesn't respect the transaction attributes because called as local operations?
        //    this.AddAttendees(eventId, attendeeIds);
        //    string status = this.ReserveRoom(eventId, roomId);
        //    string status2 = this.ReserveCatering(eventId, roomId, menuOptionId);
            
        //}

        #endregion


    }

    

}
