using System;
using System.Collections.Generic;
using System.Text;

using System.ServiceModel;
using System.ServiceModel.Configuration;
using System.ServiceModel.Description;
using System.ServiceModel.Dispatcher;
using System.ServiceModel.Channels;
using System.IO;

namespace Seroter.BizTalkWCFTutorials.AttachmentTranxExample
{
    //using some code from Brian McNamara at http://forums.microsoft.com/MSDN/ShowPost.aspx?PostID=1502796&SiteID=1
    public class AttachmentMessageInspector : IDispatchMessageInspector
    {
        MessageEncodingBindingElement mebe;
        public AttachmentMessageInspector(MessageEncodingBindingElement mebe)
        {
            this.mebe = mebe;

        }


        #region IDispatchMessageInspector Members

        public object AfterReceiveRequest(ref Message request, IClientChannel channel, InstanceContext instanceContext)
        {
          
            return null;
            
        }

        public void BeforeSendReply(ref Message reply, object correlationState)
        {
            MessageBuffer buf = reply.CreateBufferedCopy(int.MaxValue);

            reply = buf.CreateMessage();
            Message remporaryMsg = buf.CreateMessage();

            remporaryMsg.Headers.Clear();
            MessageEncoder me = this.mebe.CreateMessageEncoderFactory().Encoder;

            MemoryStream memStream = new MemoryStream();
            me.WriteMessage(remporaryMsg, memStream);

            System.Diagnostics.Trace.WriteLine("Message size is ... " + memStream.Length.ToString());
  
        }

        #endregion
    }

    public class AttachmentEndpointBehavior : IEndpointBehavior
    {

        public void AddBindingParameters(ServiceEndpoint endpoint, BindingParameterCollection bindingParameters)
        {
            
        }

        public void ApplyClientBehavior(ServiceEndpoint endpoint, ClientRuntime clientRuntime)
        {
            
        }

        /// <summary>
        /// Apply behavior at runtime
        /// </summary>
        /// <param name="endpoint"></param>
        /// <param name="endpointDispatcher"></param>
        public void ApplyDispatchBehavior(ServiceEndpoint endpoint, EndpointDispatcher endpointDispatcher)
        {

            MessageEncodingBindingElement mebe = endpoint.Binding.CreateBindingElements().Find<MessageEncodingBindingElement>();
            endpointDispatcher.DispatchRuntime.MessageInspectors.Add(new AttachmentMessageInspector(mebe));
        }

        public void Validate(ServiceEndpoint endpoint)
        {

        }
    }

    /// <summary>
    /// Needed so that the behavior can be set in the configuration file
    /// </summary>
    public class AttachementTracingElement : BehaviorExtensionElement
    {
        // BehaviorExtensionElement members
        public override Type BehaviorType
        {
            get { return typeof(AttachmentEndpointBehavior); }
        }

        protected override object CreateBehavior()
        {
            return new AttachmentEndpointBehavior();
        }

    }



}
