using System;
using System.Collections.Generic;
using System.Text;

using System.ServiceModel;
using System.ServiceModel.Channels;
using System.ServiceModel.Description;
using System.ServiceModel.Configuration;
using System.IdentityModel.Policy;
using System.IdentityModel.Claims;
using System.Security;
using System.Security.Principal;
using System.Threading;
using System.Configuration; //for config property attribute

namespace Seroter.BizTalkWCFTutorials.Publish.Utilities
{
    public class BizTalkCustomServiceAuthManager : ServiceAuthorizationManager
    {
        private string m_windowsgroup;

        public BizTalkCustomServiceAuthManager(string windowsgroup)
        {
            this.m_windowsgroup = windowsgroup;
        }

        protected override bool CheckAccessCore(OperationContext operationContext)
        {
            //check that basic access is ok before checking our custom conditions
            if (!base.CheckAccessCore(operationContext))
            {
                return false;
            }

            //AuthorizationContext authContext = operationContext.ServiceSecurityContext.AuthorizationContext;

            //IPrincipal principal = authContext.Properties["Principal"] as IPrincipal;

            System.Diagnostics.Trace.WriteLine("Primary Identity is " + operationContext.ServiceSecurityContext.PrimaryIdentity.Name);
            System.Diagnostics.Trace.WriteLine("Windows Identity is " + operationContext.ServiceSecurityContext.WindowsIdentity.Name);

            WindowsPrincipal p = new WindowsPrincipal(operationContext.ServiceSecurityContext.WindowsIdentity);

            bool isAdmin = p.IsInRole(this.m_windowsgroup);
            System.Diagnostics.Trace.WriteLine("Passed in windows group is " + this.m_windowsgroup);

            if (!isAdmin)
            {
                return false;
            }

            //if (Thread.CurrentPrincipal.Identity == null)
            //{
            //    System.Diagnostics.Trace.WriteLine("Thread Identity is empty");
            //}
            //else
            //{
            //    System.Diagnostics.Trace.WriteLine("Thread Identity value is " + Thread.CurrentPrincipal.Identity.Name);
            //}

            //claim loop
            //System.Diagnostics.Trace.WriteLine("Claim count is " + authContext.ClaimSets.Count);

            //foreach (ClaimSet cs in authContext.ClaimSets)
            //{
            //    foreach (Claim c in cs)
            //    {
            //        System.Diagnostics.Trace.WriteLine("claim type: " + c.ClaimType);

            //        if (c.Resource is SecurityIdentifier)
            //        {
            //            ((SecurityIdentifier)c.Resource).Translate(typeof(NTAccount)).ToString();
            //        }
            //        else
            //        {
            //            System.Diagnostics.Trace.WriteLine("claim resource: " + c.Resource.ToString());
            //        }
                    
            //        System.Diagnostics.Trace.WriteLine("claim right: " + c.Right);
            //    }
            //}
            
            
            return true;
        }

    }

    public class BizTalkCustomServiceBehavior : IServiceBehavior
    {
        private string m_windowsgroup;

        /// <summary>
        /// Store windows group defined in configuration
        /// </summary>
        /// <param name="windowsgroup"></param>
        public BizTalkCustomServiceBehavior(string windowsgroup)
        {
            this.m_windowsgroup = windowsgroup;
        }

        #region IServiceBehavior Members

        public void AddBindingParameters(ServiceDescription serviceDescription, ServiceHostBase serviceHostBase, System.Collections.ObjectModel.Collection<ServiceEndpoint> endpoints, BindingParameterCollection bindingParameters)
        {
            
        }

        public void ApplyDispatchBehavior(ServiceDescription serviceDescription, ServiceHostBase serviceHostBase)
        {
            ServiceAuthorizationBehavior authBehavior = serviceDescription.Behaviors.Find<ServiceAuthorizationBehavior>();
            //pass in Windows Group set in config
            authBehavior.ServiceAuthorizationManager = new BizTalkCustomServiceAuthManager(this.m_windowsgroup);

            ((IServiceBehavior)authBehavior).ApplyDispatchBehavior(serviceDescription, serviceHostBase);
        }

        public void Validate(ServiceDescription serviceDescription, ServiceHostBase serviceHostBase)
        {

        }

        #endregion
    }

    /// <summary>
    /// Needed for this behavior to be available in the configuration file
    /// </summary>
    public class BizTalkCustomBehaviorElement : BehaviorExtensionElement
    {
        /// <summary>
        /// Want custom config property to show up in the BizTalk receive location
        /// </summary>
        [ConfigurationProperty("windowsgroup", IsRequired = false, DefaultValue = "")]
        public string WindowsGroup
        {
            get { return (string)base["windowsgroup"]; }
            set { base["windowsgroup"] = value; }
        }
        
        protected override object CreateBehavior()
        {
            return new BizTalkCustomServiceBehavior(WindowsGroup);
        }

        public override Type BehaviorType
        {
            get
            {
                return typeof(BizTalkCustomServiceBehavior);
            }
        }
    }
}
