using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.IO;
using System.Transactions;

using System.ServiceModel;
using System.ServiceModel.Channels;
using OneWay = Seroter.BizTalkWCFTutorials.ServiceTestConsumer.PublishOneWayOperationClient;
using TwoWay = Seroter.BizTalkWCFTutorials.ServiceTestConsumer.PublishTwoWayOperationClient;
using TwoWaySimple = Seroter.BizTalkWCFTutorials.ServiceTestConsumer.PublishTwoWaySimpleOperationClient;
using TwoWayMulti = Seroter.BizTalkWCFTutorials.ServiceTestConsumer.PublishTwoWayMultiOperationClient;
using TwoWayFault = Seroter.BizTalkWCFTutorials.ServiceTestConsumer.PublishTwoWayFaultOperationClient;
using SecureMessage = Seroter.BizTalkWCFTutorials.ServiceTestConsumer.PublishSecureMessageClient;
using Attach = Seroter.BizTalkWCFTutorials.ServiceTestConsumer.PublishAttachmentClient;
using Tranx = Seroter.BizTalkWCFTutorials.ServiceTestConsumer.PublishTransactionClient;

namespace Seroter.BizTalkWCFTutorials.Publish.ServiceTestConsumer
{
    public partial class ServiceTester : Form
    {
        public ServiceTester()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {

            using (OneWay.OneWayOperationServiceClient client = new OneWay.OneWayOperationServiceClient("WSHttpBinding_ITwoWayAsyncVoid_OneWayTest"))
                {
                    OneWay.BulkOrder order = new OneWay.BulkOrder();
                    order.CustomerID = "12345";
                    order.DeliveryDate = "03/01/2008";
                    order.OrderID = "abc123";
                    order.Status = "Submitted";

                    OneWay.BulkOrderProductDetails details = new OneWay.BulkOrderProductDetails();
                    details.ItemID = "sku99203";
                    details.Quantity = 25;

                    order.ProductDetails = details;

                    client.PublishBulkOrder(order);

                    MessageBox.Show("success");
                }
           

            
        }

        private void button2_Click(object sender, EventArgs e)
        {
            using (TwoWay.Seroter_BizTalkWCFTutorials_Publish_BizTalk_ProcessTwoWayRequest_ReceiveBulkOrderPortClient client =
                new Seroter.BizTalkWCFTutorials.ServiceTestConsumer.PublishTwoWayOperationClient.Seroter_BizTalkWCFTutorials_Publish_BizTalk_ProcessTwoWayRequest_ReceiveBulkOrderPortClient("WSHttpBinding_ITwoWayAsync_TwoWayTest"))
            {
                TwoWay.BulkOrder order = new TwoWay.BulkOrder();
                order.CustomerID = "98765";
                order.DeliveryDate = "03/14/2008";
                order.OrderID = "xyz098";
                order.Status = "Submitted";

                TwoWay.BulkOrderProductDetails details = new TwoWay.BulkOrderProductDetails();
                details.ItemID = "sku100056";
                details.Quantity = 25;

                order.ProductDetails = details;

                TwoWay.PublishBulkOrderRequest t = new Seroter.BizTalkWCFTutorials.ServiceTestConsumer.PublishTwoWayOperationClient.PublishBulkOrderRequest();
                
                //call operation, passing order by reference
                client.PublishBulkOrder(ref order);

                MessageBox.Show("success - status: " + order.Status);

            }
            
            
            //create generic client, FAILED
            //using (TwoWay.TwoWayAsyncClient client = new TwoWay.TwoWayAsyncClient("WSHttpBinding_ITwoWayAsync_TwoWayTest"))
            //{
            //    //create typed object
            //    TwoWay.BulkOrder order = new TwoWay.BulkOrder();
            //    order.CustomerID = "98765";
            //    order.DeliveryDate = "03/14/2008";
            //    order.OrderID = "xyz098";
            //    order.Status = "Submitted";

            //    TwoWay.BulkOrderProductDetails details = new TwoWay.BulkOrderProductDetails();
            //    details.ItemID = "sku100056";
            //    details.Quantity = 25;

            //    //create message using typed object as the body (action must match endpoint action)
            //    System.ServiceModel.Channels.Message bulkOrderMsg = System.ServiceModel.Channels.Message.CreateMessage(MessageVersion.Soap12WSAddressing10, "BizTalkSubmit", order);

                
            //    //call generic submit operation
            //    //according to docs, the "BizTalkSubmit" option can never be called and results in NotSupportedException
            //    //System.ServiceModel.Channels.Message bulkOrderMsgResponse = client.BizTalkSubmit(bulkOrderMsg);

            //    //get typed response value
            //    //TwoWay.BulkOrder response = bulkOrderMsgResponse.GetBody<TwoWay.BulkOrder>();

                

            //}
        }

        private void button3_Click(object sender, EventArgs e)
        {
            
            //SOAPSvc.WebService_Seroter_BizTalkWCFTutorials_Publish_BizTalk soapClient = new Seroter.BizTalkWCFTutorials.Publish.ServiceTestConsumer.SOAPSvc.WebService_Seroter_BizTalkWCFTutorials_Publish_BizTalk();
            //soapClient.PublishStockQuery(12345);


            using (TwoWaySimple.Seroter_BizTalkWCFTutorials_Publish_BizTalk_ProcessTwoWayRequestSimple_ReceiveStockQueryPortClient client =
                new Seroter.BizTalkWCFTutorials.ServiceTestConsumer.PublishTwoWaySimpleOperationClient.Seroter_BizTalkWCFTutorials_Publish_BizTalk_ProcessTwoWayRequestSimple_ReceiveStockQueryPortClient("NetTcpBinding_ITwoWayAsync_SimpleTest"))
            {
                string status = client.PublishStockQuery(12345);

                MessageBox.Show("success - " + status);
            }
        }

        private void button4_Click(object sender, EventArgs e)
        {
            //SOAPSvc.WebService_Seroter_BizTalkWCFTutorials_Publish_BizTalk soapClient = new Seroter.BizTalkWCFTutorials.Publish.ServiceTestConsumer.SOAPSvc.WebService_Seroter_BizTalkWCFTutorials_Publish_BizTalk();
            //soapClient.PublishBulkOrder("12345", null);

            using (TwoWayMulti.Seroter_BizTalkWCFTutorials_Publish_BizTalk_ProcessTwoWayRequestMultiPart_ReceiveMultiPartBulkOrderClient client =
            new Seroter.BizTalkWCFTutorials.ServiceTestConsumer.PublishTwoWayMultiOperationClient.Seroter_BizTalkWCFTutorials_Publish_BizTalk_ProcessTwoWayRequestMultiPart_ReceiveMultiPartBulkOrderClient("WSHttpBinding_ITwoWayAsync_TwoWayTestMulti"))
            {
                TwoWayMulti.BulkOrder order = new TwoWayMulti.BulkOrder();
                order.CustomerID = "98765";
                order.DeliveryDate = "03/14/2008";
                order.OrderID = "xyz098";
                order.Status = "Submitted";

                TwoWayMulti.BulkOrderProductDetails details = new TwoWayMulti.BulkOrderProductDetails();
                details.ItemID = "sku100056";
                details.Quantity = 25;

                order.ProductDetails = details;

                client.PublishBulkOrder(ref order);

                MessageBox.Show("success = " + order.Status);
            }
        }

        private void button5_Click(object sender, EventArgs e)
        {
            using(TwoWayFault.Seroter_BizTalkWCFTutorials_Publish_BizTalk_ProcessTwoWayRequestWithFault_ReceiveBulkOrderPortClient client = 
                new Seroter.BizTalkWCFTutorials.ServiceTestConsumer.PublishTwoWayFaultOperationClient.Seroter_BizTalkWCFTutorials_Publish_BizTalk_ProcessTwoWayRequestWithFault_ReceiveBulkOrderPortClient("WSHttpBinding_ITwoWayAsync_TwoWayTestFault"))
            {
                TwoWayFault.BulkOrder order = new TwoWayFault.BulkOrder();
                order.CustomerID = "98765";
                order.DeliveryDate = "03/14/2008";
                order.OrderID = "xyz098";
                order.Status = "Submitted";

                TwoWayFault.BulkOrderProductDetails details = new TwoWayFault.BulkOrderProductDetails();
                details.ItemID = "sku100056";
                details.Quantity = 25;

                order.ProductDetails = details;

                client.PublishBulkOrder(ref order);

                MessageBox.Show("success");
            }
        }

        private void button6_Click(object sender, EventArgs e)
        {
            //WSHttpBinding_ITwoWayAsync_SecureMessageTest
            //NetTcpBinding_ITwoWayAsync_AdvancedTest
            using (SecureMessage.Seroter_BizTalkWCFTutorials_Publish_BizTalk_ProcessSecureMessageRequest_ReceiveMessageSecureCustomerPortClient client =
            new SecureMessage.Seroter_BizTalkWCFTutorials_Publish_BizTalk_ProcessSecureMessageRequest_ReceiveMessageSecureCustomerPortClient("WSHttpBinding_ITwoWayAsync_SecureMessageTest"))
            {
                SecureMessage.NewCustomer customer =
                    new SecureMessage.NewCustomer();

                customer.CustomerId = "";
                customer.LastName = "Griffin";
                customer.FirstName = "Chris";
                customer.City = "Quahog";
                customer.State = "RI";
                customer.Company = "Toys, Inc.";
                customer.ReferredBy = "";
                customer.Status = "Submitted";

                client.PublishNewCustomer(ref customer);

                MessageBox.Show("Cust ID is " + customer.CustomerId);
            }
        }

        private void button7_Click(object sender, EventArgs e)
        {
            //WSHttpBinding_ITwoWayAsync_SecureTransportTest

            //reuse proxy class since the same contract is used; only difference is configuration binding
            using (SecureMessage.Seroter_BizTalkWCFTutorials_Publish_BizTalk_ProcessSecureMessageRequest_ReceiveMessageSecureCustomerPortClient client =
            new SecureMessage.Seroter_BizTalkWCFTutorials_Publish_BizTalk_ProcessSecureMessageRequest_ReceiveMessageSecureCustomerPortClient("WSHttpBinding_ITwoWayAsync_SecureTransportTest"))
            {
                SecureMessage.NewCustomer customer =
                    new SecureMessage.NewCustomer();

                customer.CustomerId = "";
                customer.LastName = "Griffin";
                customer.FirstName = "Chris";
                customer.City = "Quahog";
                customer.State = "RI";
                customer.Company = "Toys, Inc.";
                customer.ReferredBy = "";
                customer.Status = "Submitted";

                client.PublishNewCustomer(ref customer);

                MessageBox.Show("Cust ID is " + customer.CustomerId);
            }
        }

        private void button8_Click(object sender, EventArgs e)
        {
            //WSHttpBinding_ITwoWayAsync_AttachTest

            using (Attach.Seroter_BizTalkWCFTutorials_Publish_BizTalk_ProcessAttachmentRequest_ReceiveEmployeeRecordRequestPortClient client =
            new Attach.Seroter_BizTalkWCFTutorials_Publish_BizTalk_ProcessAttachmentRequest_ReceiveEmployeeRecordRequestPortClient("WSHttpBinding_ITwoWayAsync_AttachTest"))
            {
                Attach.EmployeeRecord employee = new Attach.EmployeeRecord();
                employee.EmpId = "12344";
                employee.Name = "";
                employee.HireDate = "";
                employee.Headshot = System.IO.File.ReadAllBytes(@"C:\Data\My Pictures\noah.jpg");

                client.SubmitRequest(ref employee);

                MemoryStream imageStream = new MemoryStream(employee.Headshot);

                pictureBox1.Image = Image.FromStream(imageStream);

                imageStream.Close();
            }
        }

        private void button9_Click(object sender, EventArgs e)
        {
            using (System.Transactions.TransactionScope trans = new TransactionScope(TransactionScopeOption.RequiresNew))
            {

                using (Tranx.Seroter_BizTalkWCFTutorials_Publish_BizTalk_ProcessTransactionalMessageRequest_ReceiveTransactionMessagePortClient client =
                new Tranx.Seroter_BizTalkWCFTutorials_Publish_BizTalk_ProcessTransactionalMessageRequest_ReceiveTransactionMessagePortClient("WSHttpBinding_ITwoWayAsyncVoid_TranxTest"))
                {
                    Tranx.RushOrder order = new Tranx.RushOrder();

                    order.CustomerID = "1234";
                    order.ItemID = "abc13";
                    order.Quantity = "200";
                    order.Status = "Submitted";
                    order.DeliveryDate = DateTime.Parse("03/22/2008");

                    client.PublishRushOrder(order);

                    MessageBox.Show("done");

                    //trans.Complete();

                }
            }
        }
    }
}