using System;
using System.ServiceModel;
using System.IO;

using OracleDBBindingNamespace;
using microsoft.lobservices.oracledb._2007._03.POLLINGSTMTOrderList;

namespace Seroter.BizTalkWCFTutorials.AdapterPack.SvcModelWinUI
{

 
    [ServiceBehavior(InstanceContextMode=InstanceContextMode.Single)]
    public class OrderPollingService : OracleDBBindingService
    {
        public override POLLINGSTMTResponse POLLINGSTMT(POLLINGSTMTRequest request)
        {
            if(request.POLLINGSTMTRECORD.Length > 0)
            {
                //open up file for writing
                StreamWriter sw = File.AppendText(@"C:\WCFTrace.txt");
                sw.WriteLine("--------- new orders found ----------");

                foreach (POLLINGSTMTRECORD order in request.POLLINGSTMTRECORD)
                {
                    sw.WriteLine("customer: " + order.CUSTOMERID +
                        "  order ID: " + order.ORDERID +
                        "  order status: " + order.ORDERSTATUS);
                }

                sw.Close();
            }

            POLLINGSTMTResponse response = new POLLINGSTMTResponse();
            return response;
        }
    }

   
    
    internal class MyServiceHost
    {
        internal static ServiceHost orderServiceHost = null;

        internal static void StartService()
        {
            //create instance of service
            OrderPollingService singletonSvc = new OrderPollingService();

            //create base URI using adapter instance
            Uri[] baseUri = new Uri[] { new Uri("oracledb://adapterdemodb") };
           
            // Instantiate new ServiceHost 
            orderServiceHost = new ServiceHost(singletonSvc, baseUri);
            

            orderServiceHost.Open();
        }

        internal static void StopService()
        {
            // Call StopService from your shutdown logic (i.e. dispose method)
            if (orderServiceHost.State != CommunicationState.Closed)
                orderServiceHost.Close();
        }
    }
}

