using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using Oracle.DataAccess.Client;


using microsoft.lobservices.oracledb._2007._03;
using microsoft.lobservices.oracledb._2007._03.BIZTALK_DEV.Procedure.GETORDERSFORCUSTOMERSTRONG;

namespace Seroter.BizTalkWCFTutorials.AdapterPack.SvcModelWinUI
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void btnInsert_Click(object sender, EventArgs e)
        {
            using (System.Transactions.TransactionScope ts = new System.Transactions.TransactionScope())
            {
                using (BIZTALK_DEVTableORDERSClient orderClient = new BIZTALK_DEVTableORDERSClient("OracleDBBinding_BIZTALK_DEV.Table.ORDERS"))
                {
                    orderClient.ClientCredentials.UserName.UserName = "xxxxx";
                    orderClient.ClientCredentials.UserName.Password = "xxxxx";

                    ORDERSRECORDINSERT[] orders = new ORDERSRECORDINSERT[1];
                    ORDERSRECORDINSERT order = new ORDERSRECORDINSERT();
                    order.CUSTOMERID = "2";
                    order.ORDERDATE = "2008-05-02";
                    order.ORDERID = "34";
                    order.ORDERSTATUS = "SUBMITTED";
                    order.ORDERSUM = "59.99";
                    orders[0] = order;

                    //second and third parameters are for bulk inserts, not multiple record inserts
                    orderClient.Insert(orders, null, null);
                }

                //MessageBox.Show("halfway done ...");

                using (BIZTALK_DEVTableORDERITEMSClient itemClient = new BIZTALK_DEVTableORDERITEMSClient("OracleDBBinding_BIZTALK_DEV.Table.ORDERITEMS"))
                {
                    itemClient.ClientCredentials.UserName.UserName = "xxxxx";
                    itemClient.ClientCredentials.UserName.Password = "xxxxx";

                    ORDERITEMSRECORDINSERT[] items = new ORDERITEMSRECORDINSERT[2];
                    ORDERITEMSRECORDINSERT item1 = new ORDERITEMSRECORDINSERT();
                    ORDERITEMSRECORDINSERT item2 = new ORDERITEMSRECORDINSERT();

                    //item1 with bad ID
                    item1.ORDERID = "39";
                    item1.ORDERITEMID = "55";
                    item1.ITEMCODE = "129";
                    item1.QUANTITY = "15";
                    item1.PURCHASEPRICE = "9.99";

                    //item2 with bad ID
                    item2.ORDERID = "39";
                    item2.ORDERITEMID = "56";
                    item2.ITEMCODE = "131";
                    item2.QUANTITY = "8";
                    item2.PURCHASEPRICE = "25.99";

                    items[0] = item1;
                    items[1] = item2;

                    itemClient.Insert(items, null, null);

                }

                ts.Complete();
            }

            MessageBox.Show("done");

        }

        private void btnWeak_Click(object sender, EventArgs e)
        {
            using (BIZTALK_DEVProcedureClient procClient = new BIZTALK_DEVProcedureClient("OracleDBBinding_BIZTALK_DEV.Procedure"))
            {
                procClient.ClientCredentials.UserName.UserName = "xxxxx";
                procClient.ClientCredentials.UserName.Password = "xxxxx";

                GenRecordRow[] weakResult = procClient.GETORDERSFORCUSTOMER("2");

                string itemCode = weakResult[0].GenRecordColumn[0].ColumnValue;

                MessageBox.Show("done ... " + itemCode);
            }

            
        }

        private void btnStrong_Click(object sender, EventArgs e)
        {
            string itemCode;

            

                using (BIZTALK_DEVProcedureClient procClient = new BIZTALK_DEVProcedureClient("OracleDBBinding_BIZTALK_DEV.Procedure"))
                {

                    procClient.ClientCredentials.UserName.UserName = "xxxxxx";
                    procClient.ClientCredentials.UserName.Password = "xxxxx";

                    OITEMRECORD[] strongResult = procClient.GETORDERSFORCUSTOMERSTRONG("2");

                    itemCode = strongResult[0].ITEMCODE;


                   
                }
            

            MessageBox.Show("done (strong) ... " + itemCode);
        }

        private void btnStartPoll_Click(object sender, EventArgs e)
        {
            MyServiceHost.StartService();

            MessageBox.Show("started");
        }

        private void btnStopPolling_Click(object sender, EventArgs e)
        {
            MyServiceHost.StopService();

            MessageBox.Show("stopped");
        }


    }
}