using System;
using System.Collections.Generic;
using System.Text;
using System.ServiceModel;
using System.Runtime.Serialization;

//new
using System.ServiceModel.Web;


namespace Seroter.BizTalkWCFTutorials.AdapterPack.RESTfulSvcLib
{

    [ServiceContract()]
    [XmlSerializerFormat]
    public interface ICustomer
    {
        //get single customer
        [OperationContract]
        [WebGet(BodyStyle=WebMessageBodyStyle.Bare,
            RequestFormat=WebMessageFormat.Xml,
            ResponseFormat=WebMessageFormat.Xml,
            UriTemplate="EnterpriseOrderSystem/Customers/{customerId}")]
        CUSTOMERSRECORDSELECT GetCustomer(string customerId);

        //get all customers
        [OperationContract]
        [WebGet(BodyStyle = WebMessageBodyStyle.Bare,
            RequestFormat = WebMessageFormat.Xml,
            ResponseFormat = WebMessageFormat.Xml,
            UriTemplate = "EnterpriseOrderSystem/Customers")]
        CUSTOMERSRECORDSELECT[] GetCustomers();
        
        //update customer
        [OperationContract]
        [WebInvoke(BodyStyle=WebMessageBodyStyle.Bare,
            Method="PUT",
            RequestFormat=WebMessageFormat.Xml,
            ResponseFormat=WebMessageFormat.Xml,
           UriTemplate = "EnterpriseOrderSystem/Customers/{customerId}")]
        string UpdateCustomer(string customerId, CUSTOMERSRECORDUPDATE changedCustomer);

        //get all orders for customer .../EnterpriseOrderSystem/Customers/1234/Orders
        [OperationContract]
        [WebGet(BodyStyle = WebMessageBodyStyle.Bare,
            RequestFormat = WebMessageFormat.Xml,
            ResponseFormat = WebMessageFormat.Xml,
            UriTemplate = "EnterpriseOrderSystem/Customers/{customerId}/Orders")]
        ORDERSRECORDSELECT[] GetAllOrdersByCustomer(string customerId);

        //get single order for customer .../EnterpriseOrderSystem/Custeomers/1234/Orders/9876
        [OperationContract]
        [WebGet(BodyStyle = WebMessageBodyStyle.Bare,
            RequestFormat = WebMessageFormat.Xml,
            ResponseFormat = WebMessageFormat.Xml,
            UriTemplate = "EnterpriseOrderSystem/Customers/{customerId}/Orders/{orderId}")]
        ORDERSRECORDSELECT GetCustomerOrder(string customerId, string orderId);

    }

    public class CustomerSvc : ICustomer
    {
        public CUSTOMERSRECORDSELECT GetCustomer(string customerId)
        {
            CUSTOMERSRECORDSELECT[] customerDetails = null;

            using (BIZTALK_DEVTableCUSTOMERSClient customerClient = 
                new BIZTALK_DEVTableCUSTOMERSClient("OracleDBBinding_BIZTALK_DEV.Table.CUSTOMERS"))
            {
                customerClient.ClientCredentials.UserName.UserName = "xxxxx";
                customerClient.ClientCredentials.UserName.Password = "xxxxx";
                customerDetails = customerClient.Select("*", "CUSTOMERID='" + customerId + "'");
            }

            return customerDetails[0];
        }

        public CUSTOMERSRECORDSELECT[] GetCustomers()
        {
            CUSTOMERSRECORDSELECT[] customerDetails = null;

            using (BIZTALK_DEVTableCUSTOMERSClient customerClient = new BIZTALK_DEVTableCUSTOMERSClient("OracleDBBinding_BIZTALK_DEV.Table.CUSTOMERS"))
            {
                customerClient.ClientCredentials.UserName.UserName = "xxxxx";
                customerClient.ClientCredentials.UserName.Password = "xxxxx";
                customerDetails = customerClient.Select("*", null);
            }

            return customerDetails;
        }

        public string UpdateCustomer(string customerId, CUSTOMERSRECORDUPDATE changedCustomer)
        {
            using (BIZTALK_DEVTableCUSTOMERSClient customerClient = new BIZTALK_DEVTableCUSTOMERSClient("OracleDBBinding_BIZTALK_DEV.Table.CUSTOMERS"))
            {
                customerClient.ClientCredentials.UserName.UserName = "xxxxx";
                customerClient.ClientCredentials.UserName.Password = "xxxxx";

                string result = customerClient.Update(changedCustomer, "CUSTOMERID = '" + changedCustomer.CUSTOMERID + "'");

                return result;
            }
        }

        public ORDERSRECORDSELECT[] GetAllOrdersByCustomer(string customerId)
        {
            ORDERSRECORDSELECT[] orderDetails = null;

            using (BIZTALK_DEVTableORDERSClient orderClient = new BIZTALK_DEVTableORDERSClient("OracleDBBinding_BIZTALK_DEV.Table.ORDERS"))
            {
                orderClient.ClientCredentials.UserName.UserName = "xxxxx";
                orderClient.ClientCredentials.UserName.Password = "xxxxx";
                orderDetails = orderClient.Select("*", "CUSTOMERID='" + customerId + "'");
            }

            return orderDetails;
        }

        public ORDERSRECORDSELECT GetCustomerOrder(string customerId, string orderId)
        {
            ORDERSRECORDSELECT[] orderDetails = null;

            using (BIZTALK_DEVTableORDERSClient orderClient = new BIZTALK_DEVTableORDERSClient("OracleDBBinding_BIZTALK_DEV.Table.ORDERS"))
            {
                orderClient.ClientCredentials.UserName.UserName = "xxxxx";
                orderClient.ClientCredentials.UserName.Password = "xxxxx";
                orderDetails = orderClient.Select("*", "CUSTOMERID='" + customerId + "' AND ORDERID ='"+ orderId +"'");
            }

            return orderDetails[0];
        }
    }

    //[DataContract]
    //[Serializable]
    //public class Customer
    //{
    //    string firstName;
    //    string lastName;
    //    string customerId;

    //    [DataMember]
    //    public string FirstName
    //    {
    //        get { return firstName; }
    //        set { firstName = value; }
    //    }
    //    [DataMember]
    //    public string LastName
    //    {
    //        get { return lastName; }
    //        set { lastName = value; }
    //    }
    //    [DataMember]
    //    public string CustomerId
    //    {
    //        get { return customerId; }
    //        set { customerId = value; }
    //    }
    //}

}
